using System;

class Program
{
    const int VELICINA_MAPE = 2100000; 
    enum POLJE
    {
        PRAZNO,
        HARI,
        DEMENTOR
    }
    static int[] mapa = new int[VELICINA_MAPE];
    static int brojDementoraKojiPostoje;
    static int harijevaPozicija;
    static int relativnaPozicijaNajblizegDementora = 0;

    enum POTEZ
    {
        POCETAK,
        MagijaSever,
        MagijaJug,
        PomeriKaSeveru
    }

    static POTEZ prethodniPotez = POTEZ.POCETAK;

    static bool zivIzdrav = true;

    static void Main(string[] args)
    {
        int N = int.Parse(Console.ReadLine());
        string[] ulaz = Console.ReadLine().Split();

        mapa[VELICINA_MAPE / 2] = (int)POLJE.HARI;
        harijevaPozicija = VELICINA_MAPE / 2;
        brojDementoraKojiPostoje = N;

        for (int i = 0; i < N; i++)
        {
            int pozicijaDementora = int.Parse(ulaz[i]);

            mapa[VELICINA_MAPE / 2 + pozicijaDementora] = (int)POLJE.DEMENTOR;
        }

        while (zivIzdrav)
        {
            if (brojDementoraKojiPostoje == 0) { return; }
            if (mapa[harijevaPozicija] == (int)POLJE.DEMENTOR) { return; }

            POTEZ odabraniPotez = odaberiPotez();

            switch(odabraniPotez)
            {
                case POTEZ.MagijaSever:
                    MagijaSever(); break;
                case POTEZ.MagijaJug:
                    MagijaJug(); break;
                case POTEZ.PomeriKaSeveru:
                    PomeriKaSeveru(); break;
            }

            PomeriDementore();

            Console.Write((int)odabraniPotez);
        }
    }

    static POTEZ odaberiPotez()
    {
        POTEZ potez = POTEZ.POCETAK;
        int udaljenostNajblizegDementora = UdaljenostNajblizegDementora();

        if (udaljenostNajblizegDementora > 0 && prethodniPotez != POTEZ.MagijaSever)
        {
            potez = POTEZ.MagijaSever;
        }
        else if (udaljenostNajblizegDementora < 0 && prethodniPotez != POTEZ.MagijaJug)
        {
            potez = POTEZ.MagijaJug;
        }
        else if (prethodniPotez != POTEZ.PomeriKaSeveru) // fali logika
        {
            potez = POTEZ.PomeriKaSeveru;
        }

        return potez;
    }

    static int UdaljenostNajblizegDementora()
    {
        int relativnaPozicijaDementora = 1;
        bool nadjen = false;

        while (nadjen == false)
        {
            if (mapa[harijevaPozicija + relativnaPozicijaDementora] == (int)POLJE.DEMENTOR)
            {
                relativnaPozicijaNajblizegDementora = relativnaPozicijaDementora;
                return relativnaPozicijaDementora;
            }
            else if (mapa[harijevaPozicija - relativnaPozicijaDementora] == (int)POLJE.DEMENTOR)
            {
                relativnaPozicijaNajblizegDementora = -relativnaPozicijaDementora;
                return -relativnaPozicijaDementora;
            }
            else
            {
                relativnaPozicijaDementora++;
            }
        }

        return 0; // nece se desiti jer se svakako provera da li postoje dementori pre pozivanja funkcije
    }

    static void MagijaSever()
    {
        // znamo da je pozitivno jer se pozvala ova funkcija
        mapa[harijevaPozicija + relativnaPozicijaNajblizegDementora] = (int)POLJE.PRAZNO;
        brojDementoraKojiPostoje--;
    }

    static void MagijaJug()
    {
        mapa[harijevaPozicija - relativnaPozicijaNajblizegDementora] = (int)POLJE.PRAZNO;
        brojDementoraKojiPostoje--;
    }

    static void PomeriKaSeveru()
    {
        harijevaPozicija++;
    }

    static void PomeriDementore()
    {
        for (int i = harijevaPozicija + 1; i < mapa.Length; i++)
        {
            if (mapa[i] == (int)POLJE.DEMENTOR)
            {
                mapa[i] = (int)POLJE.PRAZNO;
                mapa[i - 1] = (int)POLJE.DEMENTOR;
            }
        }

        for (int i = harijevaPozicija - 1; i > 0; i--)
        {
            if (mapa[i] == (int)POLJE.DEMENTOR)
            {
                mapa[i] = (int)POLJE.PRAZNO;
                mapa[i + 1] = (int)POLJE.DEMENTOR;
            }
        }
    }
}